function [Dis_Edu] = MeEVagent(EPsi, Nf, e, wU_f, wU_m, wS_f, wS_m, q)

EPsim = EPsi(1);
EPsif = EPsi(2);

%% Male
qSS_m=q(1);
qSS_f=q(2);
qUS_m=q(3);
qUS_f=q(4);
qSU_m=q(5);
qSU_f=q(6);
qUU_m=q(7);
qUU_f=q(8);

EthetaSm=(1-Nf)*EPsim+Nf*EPsim*EPsif*max(qSS_m,qSS_f)+Nf*EPsim*(1-EPsif)*max(qSU_m,qSU_f);
EthetaUm=(1-Nf)*(1-EPsim)+Nf*(1-EPsim)*EPsif*max(qUS_m,qUS_f)+Nf*(1-EPsim)*(1-EPsif)*max(qUU_m,qUU_f);
EthetaSf=Nf*EPsim*EPsif*max(qSS_m,qSS_f)+Nf*(1-EPsim)*EPsif*max(qUS_m,qUS_f);
EthetaUf=Nf*EPsim*(1-EPsif)*max(qSU_m,qSU_f)+Nf*(1-EPsim)*(1-EPsif)*max(qUU_m,qUU_f);

U_SS = log(e*(wS_m+wS_f));
U_SU = log(e*(wS_m+wU_f));
U_US = log(e*(wU_m+wS_f));
U_UU = log(e*(wU_m+wU_f));


outcome_sm1 = EPsif*Nf*( (1-max(qSS_m,qSS_f))*(U_SS) + 0.5-0.5*(max(qSS_m,qSS_f))^2) ...
    + EPsif*Nf*((max(qSS_m,qSS_f))*min((EthetaSf/EthetaSm),1)*(U_SS+0.5)) ...
    + EPsif*Nf*((max(qSS_m,qSS_f))*(1-min((EthetaSf/EthetaSm),1))*log(wS_m));
    

outcome_sm2 = (1-EPsif)*Nf*( (1-max(qSU_m,qSU_f))*(U_SU) + 0.5-0.5*(max(qSU_m,qSU_f))^2) ...
    + (1-EPsif)*Nf*((max(qSU_m,qSU_f))*min((EthetaSf/EthetaSm),1)*(U_SS+0.5)) ...
    + (1-EPsif)*Nf*((max(qSS_m,qSS_f))*(1-min((EthetaSf/EthetaSm),1))*log(wS_m));


outcome_sm3 = (1-Nf)*(((min((EthetaSf/EthetaSm),1))*(U_SS+0.5)) ...
    + (1-min((EthetaSf/EthetaSm),1))*log(wS_m));


outcome_sm = outcome_sm1+outcome_sm2+outcome_sm3;


outcome_um1 = EPsif*Nf*( (1-max(qUS_m,qUS_f))*(U_US) + 0.5-0.5*(max(qSS_m,qSS_f))^2) ...
    + EPsif*Nf*((max(qUS_m,qUS_f))*min((EthetaUf/EthetaUm),1)*(U_UU+0.5)) ...
    + EPsif*Nf*((max(qUS_m,qUS_f))*(1-min((EthetaUf/EthetaUm),1))*log(wU_m));


outcome_um2 = (1-EPsif)*Nf*( (1-max(qUU_m,qUU_f))*(U_UU) + 0.5-0.5*(max(qUU_m,qUU_f))^2) ...
    + (1-EPsif)*Nf*((max(qUU_m,qUU_f))*min((EthetaUf/EthetaUm),1)*(U_UU+0.5)) ...
    + (1-EPsif)*Nf*((max(qUU_m,qUU_f))*(1-min((EthetaUf/EthetaUm),1))*log(wU_m));

outcome_um3 = (1-Nf)*(((min((EthetaUf/EthetaUm),1))*(U_UU+0.5)) ...
    + (1-min((EthetaUf/EthetaUm),1))*log(wU_m));


outcome_um = outcome_um1+outcome_um2+outcome_um3;


Diff_male = outcome_sm-outcome_um;


%% Female
outcome_sf1 = min((EPsim/Nf),1)*((1-max(qSS_m,qSS_f))*(U_SS) + 0.5-0.5*(max(qSS_m,qSS_f))^2) ...
    + min((EPsim/Nf),1)*((max(qSS_m,qSS_f))*min((EthetaSm/EthetaSf),1)*(U_SS+0.5)) ...
    + min((EPsim/Nf),1)*((max(qSS_m,qSS_f))*(1-min((EthetaSm/EthetaSf),1))*log(wS_f));
    

outcome_sf2 = min(((1-EPsim)/Nf),1)*( (1-max(qUS_m,qUS_f))*(U_US) + 0.5-0.5*(max(qUS_m,qUS_f))^2) ...
    + min(((1-EPsim)/Nf),1)*((max(qUS_m,qUS_f))*min((EthetaSm/EthetaSf),1)*(U_SS+0.5)) ...
    + min(((1-EPsim)/Nf),1)*((max(qUS_m,qUS_f))*(1-min((EthetaSm/EthetaSf),1))*log(wS_f));

outcome_sf = outcome_sf1+outcome_sf2;

outcome_uf1 = min((EPsim/Nf),1)*( (1-max(qSU_m,qSU_f))*(U_SU) + 0.5-0.5*(max(qSU_m,qSU_f))^2) ...
    + min((EPsim/Nf),1)*((max(qSU_m,qSU_f))*min((EthetaUm/EthetaUf),1)*(U_UU+0.5)) ...
    + min((EPsim/Nf),1)*((max(qSU_m,qSU_f))*(1-min((EthetaUm/EthetaUf),1))*log(wU_f));

outcome_uf2 = min(((1-EPsim)/Nf),1)*( (1-max(qUU_m,qUU_f))*(U_UU) + 0.5-0.5*(max(qUU_m,qUU_f))^2) ...
    + min(((1-EPsim)/Nf),1)*((max(qUU_m,qUU_f))*min((EthetaUm/EthetaUf),1)*(U_UU+0.5)) ...
    + min(((1-EPsim)/Nf),1)*((max(qUU_m,qUU_f))*(1-min((EthetaUm/EthetaUf),1))*log(wU_f));

outcome_uf = outcome_uf1+outcome_uf2;

Diff_female = outcome_sf-outcome_uf;


%% Final outcome difference
Dis_Edu(1) = Diff_male-EPsim;

Dis_Edu(2) = Diff_female-EPsif;

end

